;
; 㭪樨 ࠡ  ਭ  ᨬ, (C) .⥪           
;

        include support.inc
        include control.inc
        include global.inc
        include constant.inc

between macro   down,up,operation
                local   continue
                cmp     al,down         ;஢  ࠭
                jb      continue        ; al ? ய 
                cmp     al,up           ;஢  ࠭
                ja      continue        ; al ? ய 
                operation               ;८ࠧ ᨬ
continue:       endm

.data
;ͻ
;  
;ͼ
;-------------------------------;
__tblRus Label BYTE             ;  ४஢
;-------------------------------;  ⨭᪮ ॣ
    DB  ' !#$%&()*+-/'      ;  ᪨
    DB  '0123456789=?'      ;
    DB  '@'      ;
    DB  '\,_'      ;
    DB  '`㠯讫'      ;
    DB  '륣|~',7Fh   ;
;-------------------------------;
__tblLat Label BYTE             ;  ४஢
;-------------------------------;  ᪮ ॣ
    DB  'F<DULT:PBQRKVYJG'      ;  ⨭᪨
    DB  'HCNEA{WXIO}SM">Z'      ;
    DB  'f,dult;pbqrkvyjg'      ;
    DB  ''      ;
    DB  ''      ;
    DB  ''      ;
    DB  "hcnea[wxio]sm'.z"      ;
    DB  '',0FFh  ;
;-------------------------------;
_strTabs  DB  8                 ;  ⠡樨
;-------------------------------;

.code
;ͻ
; ॢ ᨬ  孨 ॣ, () .⥪                   
;͹
; Call  Assembler                                                     
;ͼ
_chrUpper proc

        between 061h,07Ah,<sub al,20h>  ;a-z
        between 0A0h,0AFh,<sub al,20h>  ;-
        between 0E0h,0EFh,<sub al,50h>  ;-
        ret
endp

;ͻ
; ॢ ᨬ   ॣ, () .⥪                    
;͹
; Call  Assembler                                                     
;ͼ
_chrLower proc

        between 041h,05Ah,<add al,20h>  ;A-Z
        between 080h,08Fh,<add al,20h>  ;-
        between 090h,09Fh,<add al,50h>  ;-
        ret
endp

;ͻ
; ॢ ᨬ  ᪨ ॣ, () .⥪                   
;͹
; Call  Assembler                                                     
;ͼ
_chrRus proc near Uses bx

    @if al += ' ' then
        @if al -- 80h then
            lea     bx,__tblRus
            sub     al,' '
            xlatb   cs:__tblRus     ;४஢ ᨬ
        @endif
    @endif
    ret
endp

;ͻ
; ॢ ᨬ  ⨭᪨ ॣ, () .⥪                 
;͹
; Call  Assembler                                                     
;ͼ
_chrLat proc near Uses bx

     @if al += 80h then
         lea    bx,__tblLat
         sub    al,80h
         xlatb  cs:__tblLat     ;४஢ ᨬ
     @endif
     ret
endp

;ͻ
; ஢,   ᨬ 㪢, () .⥪                
;͹
; Call  Assembler                                                     
;ͼ
_chrAlpha? proc near Uses ax

    call  _chrUpper
    @if al -= 'Z' then
        @if al += 'A' then
            xor ax,ax
        @endif
    @elseif al -= '' then
        @if al += '' then
            xor ax,ax
        @endif
    @endif
    ret
endp

;ͻ
; ஢,   ᨬ ன, () .⥪                
;͹
; Call  Assembler                                                     
;ͼ
_chrDigit? proc near Uses ax

    @if al += '0' then
        @if al -= '9' then
            xor ax,ax
        @endif
    @endif
    ret
endp

;ͻ
; ॢ ਭ  孨 ॣ, () .⥪                   
;͹
; Call  Assembler                                                     
;ͼ
_strUpper proc near Uses ax si

    @dowhile @byte(si) #= 0
        mov     al,[si]
        call    _chrUpper
        mov     [si],al
        inc     si
    @enddo
    ret
endp

;ͻ
; ॢ ਭ   ॣ, () .⥪                    
;͹
; Call  Assembler                                                     
;ͼ
_strLower proc near Uses ax si

    @dowhile @byte(si) #= 0
        mov     al,[si]
        call    _chrLower
        mov     [si],al
        inc     si
    @enddo
    ret
endp

;ͻ
; ।  ਭ, () .⥪                            
;͹
; Call  Assembler                                                     
;ͼ
_strLen proc near Uses si

    xor     cx,cx
    @dowhile @byte(si) #= 0
        inc     cx
        inc     si
    @enddo
    ret
endp

;ͻ
; ⠭ 㪠⥫   ਭ, (C) .⥪               
;͹
; Call  Assembler                                                     
;͹
; In    ES:DI ᮤন 㪠⥫  砫 ਭ                     
;Ķ
; Out   ES:DI ᮤন 㪠⥫   ਭ (ZERO)              
;       CX    ᮤন  ਭ                                  
;ͼ
_strEnd proc near

    xor     cx,cx
    @dowhile es:@byte(di) #= 0
        inc     cx
        inc     di
    @enddo
    ret
endp

;ͻ
; ࠢ ਭ                                                   
;͹
; Call  Assembler                                                     
;͹
; In    DS:SI ᮤন 㪠⥫   ਭ                     
;       ES:DI ᮤন 㪠⥫  ன ਭ                     
;Ķ
; Out   ZF=1  ࠢ 襭 ᯥ譮                             
;ͼ
_strComp proc near Uses di si

    @repeat
      @if <@byte(si) == 0> and <es:@byte(di) == 0> then
          xor si,si
          ret
      @endif
      @exit <@byte(si) == 0> or <es:@byte(di) == 0>
      cmpsb
    @when ZF == 1
    or si,1
    ret
endp

;ͻ
; ஢ ਭ                                                  
;͹
; Call  Assembler                                                     
;͹
; In    DS:SI ᮤন 㪠⥫  室 ਭ                   
;       ES:DI ᮤন 㪠⥫  楫 ਭ                    
;Ķ
; Out   ES:DI ᮤন 㪠⥫   楫 ਭ (ZERO)     
;       CX    ᮤন  ᪮஢ ਭ                   
;ͼ
_strCopy proc near Uses ax si

    xor cx,cx
    @repeat
        lodsb
        stosb
        inc cx
    @when al #= 0
    dec di
    dec cx
    ret
endp

;ͻ
; ᯠ ਭ                                                   
;͹
; Call  Assembler                                                     
;͹
; In    DS:SI ᮤন 㪠⥫  室 ਭ                   
;       ES:DI ᮤন 㪠⥫  楫 ਭ                    
;Ķ
; Out   CX    ᮤন  ᯠ ਭ                   
;ͼ
_strExpand proc near uses ax bx dx si di es ds

    xor cx,cx                     ;CX =  ᯠ ப.
    @dowhile @byte(si) #= 0       ;   室 ਭ.
      mov al,@byte(si)            ;ਭ । ᨬ 室
      inc si                      ;ਭ.
      @if al == HT then           ;᫨ 㦥  ⠡樨:
          mov ax,cx               ;   AX  ᯠ ப,
          mov dl,cs:_strTabs      ;  DL  蠣 ⠡樨;
          div dl                  ; ⮪   -  ᪮쪮
          sub dl,ah               ; ᨬ  ࢠ ⠡樨 㦥
          mov dh,0                ; ᪮஢,  ࠧ  蠣 
          add cx,dx               ; ⪮ - ᪮쪮 㦭 .
          mov al," "              ;   ᯠ ப
          @for dx                 ;   㦭 ᫮ ஡.
            mov es:@byte(di),al
            inc di
          @next
          @loop
      @endif
      mov es:@byte(di),al         ;᫨  । ᨬ 室
      inc di                      ;ਭ -   ⠡樨, ᪮஢
      inc cx                      ;  室 ਭ.
    @enddo
    mov es:@byte(di),0            ; 騩   室
    ret                           ;ਭ.
endp

;ͻ
; ८ࠧ 祭   ਭ                                 
;͹
; Call  Assembler                                                     
;͹
; In    DS:SI ᮤন 㪠⥫   ( 11  )                 
;       AH    ᮤন ଠ                                     
;       AL    ᮤন ࠧ⥫                                
;       CX    ᮤন                                             
;       DH    ᮤন                                           
;       DL    ᮤন                                            
;Ķ
; Out   DS:SI ᮤন 㪠⥫  祭 ਭ                 
;ͼ
_strDate proc near Uses ax bx cx dx si
   local year:word,month:byte,day:byte

    mov     year,cx     ;࠭ । .
    mov     month,dh
    mov     day,dl

    @if AH == CP_MDY then       ;᫨ 㪠 ਪ᪨ ଠ:

        call _dateMonth         ;८ࠧ ,
        call _dateSeparate      ; ࠧ⥫,
        call _dateDay           ;८ࠧ ,
        call _dateSeparate      ; ࠧ⥫,
        call _dateYear          ;८ࠧ .

    @elseif AH == CP_DMY then   ;᫨ 㪠 ய᪨ ଠ:

        call _dateDay           ;८ࠧ ,
        call _dateSeparate      ; ࠧ⥫,
        call _dateMonth         ;८ࠧ ,
        call _dateSeparate      ; ࠧ⥫,
        call _dateYear          ;८ࠧ .

    @else                       ;᫨ 㪠 ﯮ᪨ ଠ:

        call _dateYear          ;८ࠧ ,
        call _dateSeparate      ; ࠧ⥫,
        call _dateMonth         ;८ࠧ ,
        call _dateSeparate      ; ࠧ⥫,
        call _dateDay           ;८ࠧ .
    @endif

    mov @byte(si),0             ;  砭 
    ret                         ; ࠢ.
endp

_dateYear proc near Uses ax     ;८ࠧ :

    mov  ax,year                ;㧨 祭 ,
    xor  dx,dx                  ;㫨 襥 ᫮,
    mov  cx,4                   ;  = 4 ᨬ,
    call _intDCF                ;ॢ  ப 
    add  si,4                   ;६ 㪠⥫.
    ret
endp

_dateMonth proc near Uses ax    ;८ࠧ :

    xor  dx,dx                  ;㫨 祭  DX:AX.
    xor  ax,ax
    mov  al,Month               ;㧨 祭 ,
    mov  cx,2                   ;  = 2 ᨬ,
    call _intDCF                ;ॢ  ப 
    add  si,2                   ;६ 㪠⥫.
    ret
endp

_dateDay proc near Uses ax      ;८ࠧ :

    xor  dx,dx                  ;㫨 祭  DX:AX.
    xor  ax,ax
    mov  al,Day                 ;㧨 祭 ,
    mov  cx,2                   ;  = 2 ᨬ,
    call _intDCF                ;ॢ  ப 
    add  si,2                   ;६ 㪠⥫.
    ret
endp

_dateSeparate proc near

    mov  @byte(si),al           ; ࠧ⥫  
    inc  si                     ;६ 㪠⥫.
    ret
endp

;ͻ
; ८ࠧ 祭 ६  ਭ                              
;͹
; Call  Assembler                                                     
;͹
; In    DS:SI ᮤন 㪠⥫   ( 10  )                 
;       AH    ᮤন ଠ ६                                 
;       AL    ᮤন ࠧ⥫ ६                            
;       CH    ᮤন                                            
;       CL    ᮤন                                          
;       DH    ᮤন ᥪ㭤                                        
;Ķ
; Out   DS:SI ᮤন 㪠⥫  祭 ਭ                 
;ͼ
_strTime proc near Uses ax bx cx dx si
   local hours:byte,  minutes:byte, seconds:byte, \
         format:byte, separator:byte

    mov     hours,ch        ;࠭ । ६.
    mov     minutes,cl
    mov     seconds,dh
    mov     format,ah       ;࠭ ଠ 
    mov     separator,al    ;ࠧ⥫ ६.


    xor     dx,dx           ;८ࠧ ᫮ ᮢ,
    xor     ax,ax           ;뢠 12-  24-ᮢ ଠ ६:
    mov     al,hours

    @if <format == CP_12S> or <format == CP_12> then
        @if al ++ 12 then
            sub al,12
        @endif
    @endif

    mov     cx,2            ;  ᮢ = 2 ᨬ.
    call    _intDCF         ;८ࠧ  ப.
    add     si,2            ;। 㪠⥫.
    call    _timeSeparate   ; ࠧ⥫.

    mov     al,minutes      ;८ࠧ ᫮ :
    call    _intDCF         ;८ࠧ  ப.
    add     si,2            ;। 㪠⥫.

    @if <format == CP_12S> or <format == CP_24S> then
        call _timeSeparate  ; ࠧ⥫.
        mov  al,seconds     ;८ࠧ ᫮ ᥪ㭤:
        call _intDCF        ;८ࠧ  ப.
        add  si,2           ;। 㪠⥫.
    @endif

    @if <format == CP_12> or <format == CP_12S> then
        @if al ++ 12 then       ;᫨ ᯮ 12-ᮢ
            mov @byte(si),'p'   ;ଠ ⮡ࠦ ६:
        @else                   ;: p - ᫥ 㤭,
            mov @byte(si),'a'   ;          a -  㤭.
        @endif
        inc si                  ;। 㪠⥫.
    @endif
    mov @byte(si),0             ;  砭 
    ret                         ; ࠢ.
endp

_timeSeparate proc near         ; ࠧ⥫ ६:

    mov  al,separator           ;㧨 ࠧ⥫,
    mov  @byte(si),al           ;   ப 
    inc  si                     ;। 㪠⥫.
    ret
endp
end
