// Copyright (C) 2004 Id Software, Inc.
//

/*
===============================================================================

	Preprocessor settings for compiling different versions.

===============================================================================
*/

// memory debugging
//#define ID_REDIRECT_NEWDELETE
//#define ID_DEBUG_MEMORY
//#define ID_DEBUG_UNINITIALIZED_MEMORY

// HUMANHEAD mdl:  Moved this below so we can see if _ENABLE_GOLD_ is defined
// if enabled, the console won't toggle upon ~, unless you start the binary with +set com_allowConsole 1
// Ctrl+Alt+~ will always bring the console no matter what
//#define ID_CONSOLE_LOCK 0	// HUMANHEAD pdm
//#ifndef ID_CONSOLE_LOCK
//	#if defined(_WIN32) || defined(MACOS_X)
//		#ifdef _DEBUG
//			#define ID_CONSOLE_LOCK 0
//		#else
//			#define ID_CONSOLE_LOCK 1
//		#endif
//	#else
//		#define ID_CONSOLE_LOCK 0
//	#endif
//#endif
// HUMANHEAD END

// useful for network debugging, turns off 'LAN' checks, all IPs are classified 'internet'
#ifndef ID_NOLANADDRESS
	#define ID_NOLANADDRESS 0
#endif

#ifndef ID_VERSIONTAG
	#define ID_VERSIONTAG ""
	//#define ID_VERSIONTAG ".MP"
#endif

// let .dds be loaded from FS without altering pure state. only for developement.
#ifndef ID_PURE_ALLOWDDS
	#define ID_PURE_ALLOWDDS 0
#endif

// build an exe with no CVAR_CHEAT controls
#ifndef ID_ALLOW_CHEATS
	#define ID_ALLOW_CHEATS 0
#endif

#ifndef ID_ENABLE_CURL
	#define ID_ENABLE_CURL 1
#endif

// fake a pure client. useful to connect an all-debug client to a server
#ifndef ID_FAKE_PURE
	#define ID_FAKE_PURE 0
#endif

// verify checksums in clientinfo traffic
// NOTE: this makes the network protocol incompatible
#ifndef ID_CLIENTINFO_TAGS
	#define ID_CLIENTINFO_TAGS 0
#endif

// for win32 this is defined in preprocessor settings so that MFC can be
// compiled out.
//#define ID_DEDICATED

// if this is defined, the executable positively won't work with any paks other
// than the demo pak, even if productid is present.
//#define ID_DEMO_BUILD

// don't define ID_ALLOW_TOOLS when we don't want tool code in the executable.
#if defined( _WIN32 ) && !defined( ID_DEDICATED ) && !defined( ID_DEMO_BUILD )
	#define	ID_ALLOW_TOOLS
#endif

// don't do backtraces in release builds.
// atm, we have no useful way to reconstruct the trace, so let's leave it off
#define ID_BT_STUB
#ifndef ID_BT_STUB
	#if defined( __linux__ )
		#if defined( _DEBUG )
			#define ID_BT_STUB
		#endif
	#else
		#define ID_BT_STUB
	#endif
#endif

// HUMANHEAD mdl:  Moved to licensee.h
//#ifndef ID_ENFORCE_KEY
//#	if !defined( ID_DEDICATED ) && !defined( ID_DEMO_BUILD )
//#		define ID_ENFORCE_KEY 1
//#	else
//#		define ID_ENFORCE_KEY 0
//#	endif
//#endif // HUMANHEAD END

#ifndef ID_OPENAL
#	if defined( _WIN32 ) && !defined( ID_DEDICATED )
#		define ID_OPENAL 1
#	else
#		define ID_OPENAL 0
#	endif
#endif

#ifndef ID_ALLOW_D3XP
#	if defined( MACOS_X )
#		define ID_ALLOW_D3XP 0
#	else
#		define ID_ALLOW_D3XP 1
#	endif
#endif

// HUMANHEAD tmj: build automation will search and replace these if necessary
// #define _EXPIRE_
// #define _NODONGLE_
// #define _SYSTEM_BUILD_
// #define _3DR_BUILD_
// #define _T2_BUILD_
// #define _VENOM_BUILD_
// #define _ATI_BUILD_
// #define _IBETA_BUILD_
// #define _NVIDIA_BUILD_
// #define _CREATIVE_BUILD_
// #define _ENABLE_GOLD_
// #define _DISCLAIMER_
// #define _USE_SECUROM_
// #define _HH_DEMO_BUILD_
// #define _GERMAN_BUILD_
// #define _LOCALIZATION_BUILD_
// #define _DISTREAM_BUILD_
// #define _MOBILE_BUILD_
// #define _INTERNAL_BUILD_

// if enabled, the console won't toggle upon ~, unless you start the binary with +set com_allowConsole 1
// Ctrl+Alt+~ will always bring the console no matter what
#ifdef _ENABLE_GOLD_

#ifndef ID_CONSOLE_LOCK
	#if !defined _INTERNAL_BUILD_ && ( defined(_WIN32) || defined(MACOS_X) )
		#ifdef _DEBUG
			#define ID_CONSOLE_LOCK 0
		#else
			#define ID_CONSOLE_LOCK 1
		#endif
	#else
		#define ID_CONSOLE_LOCK 0
	#endif
#endif

#else // _ENABLE_GOLD_
#define ID_CONSOLE_LOCK 0
#endif
// HUMANHEAD END

// END HUMANHEAD

