program Rotten;
{$I-}
uses
  Crt,Strings,REGlbls,REWads,REInput,REGraph,REDefs,RELvls,REEdit;

var
  StartupMem:longint;
  LastCommand:array[0..8] of char;

procedure Init;
begin
  StartupMem:=MemAvail;
  StrCopy(LastCommand,'Help');

  ClrScr;
  WriteLn('ROTTen Editor v1.0  Copyright (c) 1996  Rutger van Eerd');
  WriteLn;

  WriteLn('Reading initialization file...');
  InitDefaults;

  WriteLn('Reading wad file...');
  WadDir:=ReadWadDirectory(WadFilename);
  if WadDir=nil then
    Halt(1);

  WriteLn('Reading ''wall.bin''...');
  WallDefs:=ReadPlaneDefs('wall.bin');
  if WallDefs=nil then begin
    WriteLn('Compiling ''wall.def''...');
    WallDefs:=CompilePlaneDefs('wall.def');
    if WallDefs=nil then
      Halt(1);
    WritePlaneDefs('wall.bin',WallDefs);
  end;

  WriteLn('Reading ''sprite.bin''...');
  SpriteDefs:=ReadPlaneDefs('sprite.bin');
  if SpriteDefs=nil then begin
    WriteLn('Compiling ''sprite.def''...');
    SpriteDefs:=CompilePlaneDefs('sprite.def');
    if SpriteDefs=nil then
      Halt(1);
    WritePlaneDefs('sprite.bin',SpriteDefs);
  end;

  WriteLn('Reading ''info.bin''...');
  InfoDefs:=ReadPlaneDefs('info.bin');
  if InfoDefs=nil then begin
    WriteLn('Compiling ''info.def''...');
    InfoDefs:=CompilePlaneDefs('info.def');
    if InfoDefs=nil then
      Halt(1);
    WritePlaneDefs('info.bin',InfoDefs);
  end;
end;

procedure Done;
begin
  StrDispose(WadFilename);
  DeleteWadDirectory(WadDir);
  DeletePlaneDefs(WallDefs);
  DeletePlaneDefs(SpriteDefs);
  DeletePlaneDefs(InfoDefs);
  StrDispose(LevelFilename);
  DeleteLevelDirectory(LevelDir);
  ClrScr;
  WriteLn('Thanks for using ROTTen Editor.');
end;

procedure CmBuilt;
var
  BuiltName,LevelName:array[0..79] of char;
  Dest,Src:file;
  Dummy:TLevelEntry;
  I,J:integer;
  LD:PLevelDirectory;
  Offset,Size:longint;
  Buffer:pointer;
begin
  StrCopy(LastCommand,'Built');

  if GetString('Built filename',nil,BuiltName,79)=nil then
    Exit;
  Assign(Dest,BuiltName);
  Rewrite(Dest,1);
  if IOResult<>0 then begin
    WriteLn('Error opening file ''',BuiltName,'''.');
    Exit;
  end;
  if CreateGameLevels then
    BlockWrite(Dest,RTLId,4)
  else
    BlockWrite(Dest,RTCId,4);
  BlockWrite(Dest,LevelVersion,4);
  FillChar(Dummy,SizeOf(TLevelEntry),0);
  for I:=0 to MaxLevels-1 do
    BlockWrite(Dest,Dummy,SizeOf(TLevelEntry));
  if IOResult<>0 then begin
    WriteLn('Error writing to file ''',BuiltName,'''.');
    Close(Dest);
    Exit;
  end;
  Offset:=FilePos(Dest);

  if GetString('First level filename',nil,LevelName,79)=nil then begin
    Close(Dest);
    Exit;
  end;

  I:=0;
  while StrLen(LevelName)<>0 do begin
    LD:=ReadLevelDirectory(LevelName);
    if LD=nil then begin
      Close(Dest);
      Exit;
    end;

    J:=0;
    while LD^[J]<>nil do begin
      if I=MaxLevels then begin
        WriteLn('Too many levels. Built aborted.');
        DeleteLevelDirectory(LD);
        Close(Dest);
        Exit;
      end;
      WriteLn('Adding ',LD^[J]^.Name,'...');
      Size:=LD^[J]^.WallSize+LD^[J]^.SpriteSize+LD^[J]^.InfoSize;
      GetMem(Buffer,Size);
      Assign(Src,LevelName);
      Reset(Src,1);
      Seek(Src,LD^[J]^.WallOffset);
      BlockRead(Src,Buffer^,Size);
      Close(Src);
      Seek(Dest,Offset);
      BlockWrite(Dest,Buffer^,Size);
      FreeMem(Buffer,Size);

      LD^[J]^.WallOffset:=Offset;
      LD^[J]^.SpriteOffset:=LD^[J]^.WallOffset+LD^[J]^.WallSize;
      LD^[J]^.InfoOffset:=LD^[J]^.SpriteOffset+LD^[J]^.SpriteSize;
      Offset:=FilePos(Dest);

      Seek(Dest,8+I*SizeOf(TLevelEntry));
      BlockWrite(Dest,LD^[J]^,SizeOf(TLevelEntry));
      I:=I+1;
      J:=J+1;
    end;
    DeleteLevelDirectory(LD);

    if GetString('Next level filename',nil,LevelName,79)=nil then begin
      Close(Dest);
      Exit;
    end;
  end;
  Close(Dest);
end;

procedure CmEdit;
var
  FN:array[0..79] of char;
  LN:array[0..23] of char;
  LD:PLevelDirectory;
  I,J:integer;
begin
  StrCopy(LastCommand,'Edit');

  if LevelDir=nil then begin
    WriteLn('No level file opened. Use the ''Open'' command.');
    Exit;
  end;

  if GetString('Level name','?',LN,23)=nil then
    Exit;
  if StrComp(LN,'?')=0 then begin
    I:=0;
    J:=0;
    while I<MaxLevels do begin
      if LevelDir^[I]<>nil then begin
        J:=J+1;
        WriteLn(I,': ',LevelDir^[I]^.Name);
        if J mod 23=0 then
          if Wait('Press any key to continue or ESC to abort...')=#27 then
            Break;
      end;
      I:=I+1;
    end;
    WriteLn;
    if GetString('Level name',nil,LN,23)=nil then
      Exit;
  end;

  I:=0;
  while I<MaxLevels do begin
    if LevelDir^[I]<>nil then
      if StrIComp(LN,LevelDir^[I]^.Name)=0 then
        Break;
    I:=I+1;
  end;

  if I=MaxLevels then begin
    WriteLn('Invalid level name.');
    Exit;
  end;

  WriteLn('Reading level data...');
  with LevelDir^[I]^ do
    WallPlane:=ReadLevelPlane(LevelFilename,WallOffset,WallSize,RLETag);
  if WallPlane=nil then
    Exit;
  with LevelDir^[I]^ do
    SpritePlane:=ReadLevelPlane(LevelFilename,SpriteOffset,SpriteSize,RLETag);
  if SpritePlane=nil then begin
    DeleteLevelPlane(WallPlane);
    Exit;
  end;
  with LevelDir^[I]^ do
    InfoPlane:=ReadLevelPlane(LevelFilename,InfoOffset,InfoSize,RLETag);
  if InfoPlane=nil then begin
    DeleteLevelPlane(WallPlane);
    DeleteLevelPlane(SpritePlane);
    Exit;
  end;

  EditLevel;

  LD:=nil;
  repeat
    if GetString('Level filename',LevelFilename,FN,79)=nil then begin
      DeleteLevelPlane(WallPlane);
      DeleteLevelPlane(SpritePlane);
      DeleteLevelPlane(InfoPlane);
      Exit;
    end;
    if GetString('Level name',nil,LN,23)<>nil then
      LD:=WriteLevel(FN,LN,WallPlane,SpritePlane,InfoPlane);
  until LD<>nil;

  DeleteLevelPlane(WallPlane);
  DeleteLevelPlane(SpritePlane);
  DeleteLevelPlane(InfoPlane);

  StrDispose(LevelFilename);
  DeleteLevelDirectory(LevelDir);
  LevelFilename:=StrNew(FN);
  LevelDir:=LD;
end;

procedure CmHelp;
var
  Command:array[0..8] of char;
begin
  StrCopy(LastCommand,'Help');

  WriteLn('Commands');
  WriteLn('  Built:   Built a level file containing multiple levels.');
  WriteLn('  Edit:    Edit a level in the currently opened level file.');
  WriteLn('  Help:    Show this information.');
  WriteLn('  New:     Create a new level.');
  WriteLn('  OPEn:    Open an existing level file.');
  WriteLn('  OPTions: Set program options.');
  WriteLn('  Status:  Show the current program status.');
  WriteLn('  Quit:    Quit the program.');
  WriteLn('  Wads:    List or view entries in the wad file.');
end;

procedure CmNew;
var
  FN:array[0..79] of char;
  LN:array[0..23] of char;
  LD:PLevelDirectory;
begin
  StrCopy(LastCommand,'New');

  WallPlane:=CreateLevelPlane;
  SpritePlane:=CreateLevelPlane;
  InfoPlane:=CreateLevelPlane;

  EditLevel;

  LD:=nil;
  repeat
    if GetString('Level filename',LevelFilename,FN,79)=nil then begin
      DeleteLevelPlane(WallPlane);
      DeleteLevelPlane(SpritePlane);
      DeleteLevelPlane(InfoPlane);
      Exit;
    end;
    if GetString('Level name',nil,LN,23)<>nil then
      LD:=WriteLevel(FN,LN,WallPlane,SpritePlane,InfoPlane);
  until LD<>nil;

  DeleteLevelPlane(WallPlane);
  DeleteLevelPlane(SpritePlane);
  DeleteLevelPlane(InfoPlane);

  StrDispose(LevelFilename);
  DeleteLevelDirectory(LevelDir);
  LevelFilename:=StrNew(FN);
  LevelDir:=LD;
end;

procedure CmOpen;
var
  FN:array[0..79] of char;
  LD:PLevelDirectory;
begin
  StrCopy(LastCommand,'OPEn');

  if GetString('Level filename',nil,FN,79)=nil then
    Exit;
  LD:=ReadLevelDirectory(FN);
  if LD=nil then
    Exit;

  StrDispose(LevelFilename);
  DeleteLevelDirectory(LevelDir);
  LevelFilename:=StrNew(FN);
  LevelDir:=LD;
end;

procedure CmOptions;
var
  Default,Buffer:array[0..11] of char;
  L:longint;
  R:word;

begin
  StrCopy(LastCommand,'OPTions');

  if CreateGameLevels then
    StrCopy(Default,'Yes')
  else
    StrCopy(Default,'No');
  if GetString('Create game levels',Default,Buffer,3)=nil then
    Exit;
  CreateGameLevels:=IsKeyword(Buffer,'Yes');

  Str(GameFlags,Default);
  if GetString('Game flags',Default,Buffer,11)=nil then
    Exit;
  Val(Buffer,L,R);
  if R<>0 then begin
    WriteLn('Invalid numeric format.');
    Exit;
  end;
  GameFlags:=L;

  Str(CombatFlags,Default);
  if GetString('Combat flags',Default,Buffer,11)=nil then
    Exit;
  Val(Buffer,L,R);
  if R<>0 then begin
    WriteLn('Invalid numeric format.');
    Exit;
  end;
  CombatFlags:=L;
end;

procedure CmStatus;
const
  NoYesBoolean:array[False..True] of PChar=('No','Yes');

begin
  StrCopy(LastCommand,'Status');

  WriteLn('Memory');
  WriteLn('  Free: ',MemAvail,' bytes');
  WriteLn('  Used: ',StartupMem-MemAvail,' bytes');
  WriteLn;
  WriteLn('Wad file');
  WriteLn('  Name:    ',WadFilename);
  WriteLn('  Entries: ',WadDir^.NumEntries);
  WriteLn;
  WriteLn('Level file');
  if LevelFilename<>nil then
    WriteLn('  Name: ',LevelFilename)
  else
    WriteLn('  Name: *none*');
  WriteLn;
  WriteLn('Options');
  WriteLn('  Create game levels: ',NoYesBoolean[CreateGameLevels]);
  WriteLn('  Game flags:         ',GameFlags);
  WriteLn('  Combat flags:       ',CombatFlags);
end;

procedure CmWadsList;
var
  I,J:longint;
begin
  I:=0;
  while I<WadDir^.NumEntries do begin
    GotoXY(I mod 5*16+1,WhereY);
    Write(WadDir^.Entries[I]^.Name);
    if I mod 5=4 then
      WriteLn;
    I:=I+1;
    if I mod 115=0 then
      if Wait('Press any key to continue or ESC to abort...')=#27 then
        Break;
  end;
  WriteLn;
  WriteLn(I,' entries listed.');
end;

procedure CmWadsView;
var
  Quit,Repaint:boolean;
  I:longint;
  Bitmap:PBitmap;
  S:array[0..5] of char;
begin
  InitGraphics;
  SetPalette(LoadPalette('rotten.pal'));
  SetFont(LoadFont('rotten.fon'));

  Quit:=False;
  Repaint:=True;
  I:=0;
  repeat
    if Repaint then begin
      ClearScreen(0);
      Bitmap:=nil;
      if IsWall(I) then
        Bitmap:=ReadWall(WadFilename,WadDir^.Entries[I]^.Offset,WadDir^.Entries[I]^.Size)
      else if IsFloor(I) then
        Bitmap:=ReadFloor(WadFilename,WadDir^.Entries[I]^.Offset,WadDir^.Entries[I]^.Size)
      else if IsSky(I) then
        Bitmap:=ReadSky(WadFilename,WadDir^.Entries[I]^.Offset,WadDir^.Entries[I]^.Size)
      else if IsPicture(I) then
        Bitmap:=ReadPicture(WadFilename,WadDir^.Entries[I]^.Offset,WadDir^.Entries[I]^.Size)
      else if IsTransPicture(I) then
        Bitmap:=ReadTransPicture(WadFilename,WadDir^.Entries[I]^.Offset,WadDir^.Entries[I]^.Size);
      if Bitmap<>nil then begin
        DrawBitmap(0,0,Bitmap);
        Str(Bitmap^.Width,S);
        WriteStr(160,191,S);
        WriteStr(208,191,'x');
        Str(Bitmap^.Height,S);
        WriteStr(224,191,S);
        DeleteBitmap(Bitmap);
      end;
      WriteStr(0,191,WadDir^.Entries[I]^.Name);
      Repaint:=False;
    end;

    repeat
      case GetKeyEvent of
        ke_Up:
          begin
            I:=I-1;
            if I<0 then
              I:=0;
            Repaint:=True;
          end;
        ke_Down:
          begin
            I:=I+1;
            if I>=WadDir^.NumEntries then
              I:=WadDir^.NumEntries-1;
            Repaint:=True;
          end;
        ke_PgUp:
          begin
            I:=I-16;
            if I<0 then
              I:=0;
            Repaint:=True;
          end;
        ke_PgDn:
          begin
            I:=I+16;
            if I>=WadDir^.NumEntries then
              I:=WadDir^.NumEntries-1;
            Repaint:=True;
          end;
        ke_Esc:
          Quit:=True;
      end;
    until Repaint or Quit;
  until Quit;

  DeleteFont(SetFont(nil));
  DeletePalette(SetPalette(nil));
  DoneGraphics;
end;

procedure CmWads;
var
  Quit:boolean;
  Command:array[0..8] of char;
begin
  StrCopy(LastCommand,'Wads');

  Quit:=False;
  repeat
    if GetString('Wads List/View/Exit','Exit',Command,8)=nil then
      Continue;
    if IsKeyword(Command,'List') then
      CmWadsList
    else if IsKeyword(Command,'View') then
      CmWadsView
    else if IsKeyword(Command,'Exit') then
      Quit:=True
    else
      WriteLn('Unknown command ''',Command,'''.');
  until Quit;
end;

procedure Run;
var
  Quit:boolean;
  Command:array[0..8] of char;
begin
  Quit:=False;
  repeat
    WriteLn;
    if GetString('Command',LastCommand,Command,8)=nil then
      Continue;
    if IsKeyword(Command,'Built') then
      CmBuilt
    else if IsKeyword(Command,'Edit') then
      CmEdit
    else if IsKeyword(Command,'Help') then
      CmHelp
    else if IsKeyword(Command,'New') then
      CmNew
    else if IsKeyword(Command,'OPEn') then
      CmOpen
    else if IsKeyword(Command,'OPTions') then
      CmOptions
    else if IsKeyword(Command,'Quit') then
      Quit:=True
    else if IsKeyword(Command,'Status') then
      CmStatus
    else if IsKeyword(Command,'Wads') then
      CmWads
    else
      WriteLn('Unknown command ''',Command,'''.');
  until Quit;
end;

begin
  Init;
  Run;
  Done;
end.