unit RELvls;
{$I-}
interface

const
  MaxLevels=100;
  PlaneSize=128;                        { breedte en hoogte }
  RTLId:longint=$004C5452;              { "RTL#0" }
  RTCId:longint=$00435452;              { "RTC#0" }
  LevelVersion:longint=$00000101;
  lfl_ActivatePushwalls=$00000001;

type
  PLevelEntry=^TLevelEntry;
  TLevelEntry=record
    Used:longint;
    CheckSum:longint;
    RLETag:longint;
    Flags:longint;
    WallOffset:longint;
    SpriteOffset:longint;
    InfoOffset:longint;
    WallSize:longint;
    SpriteSize:longint;
    InfoSize:longint;
    Name:array[0..23] of char;
  end;

  PLevelDirectory=^TLevelDirectory;
  TLevelDirectory=array[0..MaxLevels-1] of PLevelEntry;

  PLevelPlane=^TLevelPlane;
  TLevelPlane=array[0..PlaneSize*PlaneSize-1] of word;

  PCompressedPlane=^TCompressedPlane;
  TCompressedPlane=record
    Size:longint; { in bytes }
    Data:array[0..0] of word;
  end;

function CreateLevelDirectory:PLevelDirectory;
procedure DeleteLevelDirectory(Dir:PLevelDirectory);
function ReadLevelDirectory(Filename:PChar):PLevelDirectory;
function WriteLevel(Filename,LevelName:PChar; Wall,Sprite,Info:PLevelPlane):PLevelDirectory;
function CreateLevelPlane:PLevelPlane;
procedure DeleteLevelPlane(Plane:PLevelPlane);
function CreateCompressedPlane(Size:longint):PCompressedPlane;
procedure DeleteCompressedPlane(Plane:PCompressedPlane);
function ReadLevelPlane(Filename:PChar; Offset,Size,RLETag:longint):PLevelPlane;
function IsValidRLETag(Plane:PLevelPlane; RLETag:word):boolean;
function CompressLevelPlane(Plane:PLevelPlane; RLETag:word):PCompressedPlane;

implementation
uses
  Strings,REGlbls;

function CreateLevelDirectory:PLevelDirectory;
var
  LD:PLevelDirectory;
begin
  New(LD);
  FillChar(LD^,SizeOf(TLevelDirectory),0);
  CreateLevelDirectory:=LD;
end;

procedure DeleteLevelDirectory(Dir:PLevelDirectory);
var
  I:integer;
begin
  if Dir=nil then
    Exit;

  for I:=0 to MaxLevels-1 do
    if Dir^[I]<>nil then
      Dispose(Dir^[I]);
  Dispose(Dir);
end;

function ReadLevelDirectory(Filename:PChar):PLevelDirectory;
var
  F:file;
  FileId,Version:longint;
  I:integer;
  LD:PLevelDirectory;
begin
  ReadLevelDirectory:=nil;
  Assign(F,Filename);
  Reset(F,1);
  if IOResult<>0 then begin
    WriteLn('Error opening file ''',Filename,'''.');
    Exit;
  end;

  BlockRead(F,FileId,4);
  BlockRead(F,Version,4);
  if IOResult<>0 then begin
    WriteLn('Error reading from file ''',Filename,'''.');
    Close(F);
    Exit;
  end;
  if (FileId<>RTLId) and (FileId<>RTCId) then begin
    WriteLn('Invalid file format.');
    Close(F);
    Exit;
  end;
  if Version<>LevelVersion then begin
    WriteLn('Invalid version.');
    Close(F);
    Exit;
  end;

  New(LD);
  for I:=0 to MaxLevels-1 do begin
    New(LD^[I]);
    BlockRead(F,LD^[I]^,SizeOf(TLevelEntry));
    if IOResult<>0 then begin
      WriteLn('Error reading from file ''',Filename,'''.');
      DeleteLevelDirectory(LD);
      Close(F);
    end;
    if LD^[I]^.Used=0 then begin
      Dispose(LD^[I]);
      LD^[I]:=nil;
    end;
  end;
  Close(F);
  ReadLevelDirectory:=LD;
end;

function WriteLevel(Filename,LevelName:PChar; Wall,Sprite,Info:PLevelPlane):PLevelDirectory;
var
  RLET:word;
  WCP,SCP,ICP:PCompressedPlane;
  F:file;
  LD:PLevelDirectory;
  Dummy:TLevelEntry;
  I:integer;
begin
  WriteLevel:=nil;

  if IsValidRLETag(Wall,$4344) and IsValidRLETag(Sprite,$4344) and IsValidRLETag(Info,$4344) then
    RLET:=$4344
  else if IsValidRLETag(Wall,$4D4B) and IsValidRLETag(Sprite,$4D4B) and IsValidRLETag(Info,$4D4B) then
    RLET:=$4D4B
  else begin
    WriteLn('Unable to find valid RLE tag.');
    Exit;
  end;

  WCP:=CompressLevelPlane(Wall,RLET);
  SCP:=CompressLevelPlane(Sprite,RLET);
  ICP:=CompressLevelPlane(Info,RLET);

  Assign(F,Filename);
  Rewrite(F,1);
  if IOResult<>0 then begin
    WriteLn('Error opening file ''',Filename,'''.');
    DeleteCompressedPlane(WCP);
    DeleteCompressedPlane(SCP);
    DeleteCompressedPlane(ICP);
    Exit;
  end;

  if CreateGameLevels then
    BlockWrite(F,RTLId,4)
  else
    BlockWrite(F,RTCId,4);
  BlockWrite(F,LevelVersion,4);
  if IOResult<>0 then begin
    WriteLn('Error writing to file ''',Filename,'''.');
    DeleteCompressedPlane(WCP);
    DeleteCompressedPlane(SCP);
    DeleteCompressedPlane(ICP);
    Close(F);
    Exit;
  end;

  LD:=CreateLevelDirectory;
  New(LD^[0]);
  with LD^[0]^ do begin
    Used:=1;
    CheckSum:=0;
    RLETag:=RLET;
    if CreateGameLevels then
      Flags:=GameFlags
    else
      Flags:=CombatFlags;
    WallOffset:=8+MaxLevels*SizeOf(TLevelEntry);
    WallSize:=WCP^.Size;
    SpriteOffset:=WallOffset+WallSize;
    SpriteSize:=SCP^.Size;
    InfoOffset:=SpriteOffset+SpriteSize;
    InfoSize:=ICP^.Size;
    StrCopy(Name,LevelName);
  end;
  FillChar(Dummy,SizeOf(TLevelEntry),0);

  for I:=0 to MaxLevels-1 do
    if LD^[I]<>nil then
      BlockWrite(F,LD^[I]^,SizeOf(TLevelEntry))
    else
      BlockWrite(F,Dummy,SizeOf(TLevelEntry));

  BlockWrite(F,WCP^.Data,WCP^.Size);
  BlockWrite(F,SCP^.Data,SCP^.Size);
  BlockWrite(F,ICP^.Data,ICP^.Size);
  if IOResult<>0 then begin
    WriteLn('Error writing to file ''',Filename,'''.');
    DeleteCompressedPlane(WCP);
    DeleteCompressedPlane(SCP);
    DeleteCompressedPlane(ICP);
    DeleteLevelDirectory(LD);
    Close(F);
    Exit;
  end;

  Close(F);
  DeleteCompressedPlane(WCP);
  DeleteCompressedPlane(SCP);
  DeleteCompressedPlane(ICP);
  WriteLevel:=LD;
end;

function CreateLevelPlane:PLevelPlane;
var
  LP:PLevelPlane;
begin
  New(LP);
  FillChar(LP^,SizeOf(TLevelPlane),0);
  CreateLevelPlane:=LP;
end;

procedure DeleteLevelPlane(Plane:PLevelPlane);
begin
  if Plane<>nil then
    Dispose(Plane);
end;

function CreateCompressedPlane(Size:longint):PCompressedPlane;
var
  CP:PCompressedPlane;
begin
  GetMem(CP,4+Size);
  CP^.Size:=Size;
  FillChar(CP^.Data,Size,0);
  CreateCompressedPlane:=CP;
end;

procedure DeleteCompressedPlane(Plane:PCompressedPlane);
begin
  if Plane<>nil then
    FreeMem(Plane,4+Plane^.Size);
end;

function ReadLevelPlane(Filename:PChar; Offset,Size,RLETag:longint):PLevelPlane;
var
  F:file;
  Buffer:PWordArray;
  LP:PLevelPlane;
  I,J,RLEN,RLEW:word;
begin
  ReadLevelPlane:=nil;
  Assign(F,Filename);
  Reset(F,1);
  if IOResult<>0 then begin
    WriteLn('Error opening file ''',Filename,'''.');
    Exit;
  end;

  Seek(F,Offset);
  GetMem(Buffer,Size);
  BlockRead(F,Buffer^,Size);
  if IOResult<>0 then begin
    WriteLn('Error reading from file ''',Filename,'''.');
    FreeMem(Buffer,Size);
    Close(F);
    Exit;
  end;
  Close(F);

  LP:=CreateLevelPlane;
  I:=0;
  J:=0;
  while I<(Size div 2) do begin
    if Buffer^[I]=RLETag then begin
      RLEN:=Buffer^[I+1];
      RLEW:=Buffer^[I+2];
      while RLEN>0 do begin
        LP^[J]:=RLEW;
        RLEN:=RLEN-1;
        J:=J+1;
      end;
      I:=I+3;
    end else begin
      LP^[J]:=Buffer^[I];
      I:=I+1;
      J:=J+1;
    end;
  end;
  FreeMem(Buffer,Size);
  ReadLevelPlane:=LP;
end;

function IsValidRLETag(Plane:PLevelPlane; RLETag:word):boolean;
var
  I:word;
begin
  IsValidRLETag:=True;
  for I:=0 to SizeOf(TLevelPlane) div 2-1 do
    if Plane^[I]=RLETag then begin
      IsValidRLETag:=False;
      Break;
    end;
end;

function CompressLevelPlane(Plane:PLevelPlane; RLETag:word):PCompressedPlane;
var
  LP:PLevelPlane;
  RLEN,RLEW:word;
  I,J:word;
  CP:PCompressedPlane;
begin
  LP:=CreateLevelPlane;
  I:=0;
  J:=0;
  while I<SizeOf(TLevelPlane) div 2 do begin
    RLEN:=1;
    RLEW:=Plane^[I];
    I:=I+1;
    while (I<SizeOf(TLevelPlane) div 2) and (Plane^[I]=RLEW) do begin
      RLEN:=RLEN+1;
      I:=I+1;
    end;
    if RLEN>3 then begin
      LP^[J]:=RLETag;
      J:=J+1;
      LP^[J]:=RLEN;
      J:=J+1;
      LP^[J]:=RLEW;
      J:=J+1;
    end else
      while RLEN>0 do begin
        LP^[J]:=RLEW;
        J:=J+1;
        RLEN:=RLEN-1;
      end;
  end;

  CP:=CreateCompressedPlane(J*2);
  Move(LP^,CP^.Data,J*2);
  DeleteLevelPlane(LP);
  CompressLevelPlane:=CP;
end;

begin
end.