unit REInput;
interface

function Wait(Prompt:PChar):char;
function IsKeyword(Str,Keyword:PChar):boolean;
function GetString(Prompt,Default,Buffer:PChar; MaxLen:word):PChar;

implementation
uses
  Crt,Strings;

function Wait(Prompt:PChar):char;
var
  Key:char;
begin
  if Prompt<>nil then
    WriteLn(Prompt);
  Key:=ReadKey;
  if Key=#0 then
    ReadKey;
  Wait:=Key;
end;

function IsKeyword(Str,Keyword:PChar):boolean;
var
  I:word;
begin
  IsKeyword:=False;
  for I:=0 to StrLen(Str) do begin
    if (Keyword[I]=#0) and (Str[I]<>#0) then
      Exit;
    if (Str[I]=#0) and (Keyword[I] in ['A'..'Z']) then
      Exit;
    if (Str[I]<>#0) and (UpCase(Str[I])<>UpCase(Keyword[I])) then
      Exit;
  end;
  IsKeyword:=True;
end;

function GetString(Prompt,Default,Buffer:PChar; MaxLen:word):PChar;
var
  Key:char;
  L:word;
begin
  StrCopy(Buffer,'');
  if Default=nil then
    Write(Prompt,': ')
  else
    Write(Prompt,' <',Default,'>: ');

  repeat
    Key:=ReadKey;
    L:=StrLen(Buffer);
    case Key of
      #0:
        ReadKey;
      #8:
        if L>0 then begin
          Buffer[L-1]:=#0;
          Write(#8,' ',#8);
        end;
      #13:
        begin
          if (L=0) and (Default<>nil) then
            StrCopy(Buffer,Default);
          WriteLn;
          GetString:=Buffer;
        end;
      #27:
        begin
          GetString:=nil;
          WriteLn;
        end;
      #32..#255:
        if L<MaxLen then begin
          Buffer[L]:=Key;
          Buffer[L+1]:=#0;
          Write(Key);
        end;
    end;
  until (Key=#13) or (Key=#27);
end;

begin
end.