unit REGlbls;
{$I-}
interface
uses
  REWads,RELvls,REDefs;

type
  PWordArray=^TWordArray;
  TWordArray=array[0..0] of word;

var
  WadFilename:PChar;
  WadDir:PWadDirectory;
  LevelFilename:PChar;
  LevelDir:PLevelDirectory;
  CreateGameLevels:boolean;
  GameFlags,CombatFlags:longint;
  WallPlane,SpritePlane,InfoPlane:PLevelPlane;
  WallDefs,SpriteDefs,InfoDefs:PPlaneDef;

procedure InitDefaults;
function WadEntryWithName(Name:PChar):longint;
function IsTag(Index:longint):boolean;
function IsFloor(Index:longint):boolean;
function IsSky(Index:longint):boolean;
function IsWall(Index:longint):boolean;
function IsPicture(Index:longint):boolean;
function IsTransPicture(Index:longint):boolean;

implementation
uses
  Strings;

procedure InitDefaults;
var
  Str,Arg:array[0..255] of char;
  I:word;

  function GetNextArg:boolean;
  var
    L:word;
  begin
    GetNextArg:=False;
    StrCopy(Arg,'');
    L:=0;
    while (Str[I]=#9) or (Str[I]=' ') do
      I:=I+1;
    if (Str[I]<>';') and (Str[I]<>#0) then begin
      if Str[I]<>'"' then begin
        WriteLn(Str);
        WriteLn('Arguments must start with ''"''.');
        Exit;
      end;
      I:=I+1;
      while (Str[I]<>'"') and (Str[I]<>#0) do begin
        Arg[L]:=Str[I];
        Arg[L+1]:=#0;
        I:=I+1;
        L:=L+1;
      end;
      if Str[I]<>'"' then begin
        WriteLn(Str);
        WriteLn('Arguments must end with ''"''.');
        Exit;
      end;
    end;
    GetNextArg:=True;
  end;

var
  F:text;
  Option:array[0..255] of char;
  L:longint;
  R:word;

begin
  WadFilename:=StrNew('darkwar.wad');
  CreateGameLevels:=True;
  GameFlags:=lfl_ActivatePushwalls;
  CombatFlags:=0;

  Assign(F,'rotten.ini');
  Reset(F);
  if IOResult<>0 then begin
    WriteLn('Error opening file ''rotten.ini''.');
    Exit;
  end;

  while not Eof(F) do begin
    ReadLn(F,Str);
    I:=0;
    if not GetNextArg then begin
      Close(F);
      Exit;
    end;
    if (Str[I]=';') or (Str[I]=#0) then
      Continue;
    StrCopy(Option,Arg);

    I:=I+1;
    if not GetNextArg then begin
      Close(F);
      Exit;
    end;
    if (Str[I]=';') or (Str[I]=#0) then begin
      WriteLn(Str);
      WriteLn('Value argument missing.');
      Close(F);
      Exit;
    end;

    if StrIComp(Option,'WadFilename')=0 then begin
      StrDispose(WadFilename);
      WadFilename:=StrNew(Arg);
    end else if StrIComp(Option,'CreateGameLevels')=0 then begin
      if StrIComp(Arg,'0')=0 then
        CreateGameLevels:=False
      else if StrIComp(Arg,'1')=0 then
        CreateGameLevels:=True
      else begin
        WriteLn(Str);
        WriteLn('Invalid option value.');
        Close(F);
        Exit;
      end;
    end else if StrIComp(Option,'GameFlags')=0 then begin
      Val(Arg,L,R);
      if R<>0 then begin
        WriteLn(Str);
        WriteLn('Invalid numeric format.');
        Close(F);
        Exit;
      end;
      GameFlags:=L;
    end else if StrIComp(Option,'CombatFlags')=0 then begin
      Val(Arg,L,R);
      if R<>0 then begin
        WriteLn(Str);
        WriteLn('Invalid numeric format.');
        Close(F);
        Exit;
      end;
      CombatFlags:=L;
    end else begin
      WriteLn(Str);
      WriteLn('Invalid option name.');
      Close(F);
      Exit;
    end;
  end;

  Close(F);
end;

function GetEntryTag(Index:longint):longint;
var
  I:longint;
begin
  I:=Index;
  while (I>=0) and (WadDir^.Entries[I]^.Size<>0) do
    I:=I-1;
  GetEntryTag:=I;
end;

function WadEntryWithName(Name:PChar):longint;
var
  I:longint;
begin
  WadEntryWithName:=-1;
  for I:=0 to WadDir^.NumEntries-1 do
    if StrIComp(WadDir^.Entries[I]^.Name,Name)=0 then begin
      WadEntryWithName:=I;
      Break;
    end;
end;

function IsTag(Index:longint):boolean;
begin
  IsTag:=WadDir^.Entries[Index]^.Size=0;
end;

function IsWall(Index:longint):boolean;
var
  I:longint;
  Tag,Entry:PWadEntry;
begin
  IsWall:=False;
  I:=GetEntryTag(Index);
  if I=-1 then
    Exit;

  Tag:=WadDir^.Entries[I];
  Entry:=WadDir^.Entries[Index];
  IsWall:=(StrComp(Tag^.Name,'WALLSTRT')=0) or
    (StrComp(Tag^.Name,'ANIMSTRT')=0) or
    ((StrComp(Tag^.Name,'EXITSTRT')=0) and (Entry^.Size=4096)) or
    (StrComp(Tag^.Name,'ABVWSTRT')=0) or
    (StrComp(Tag^.Name,'ELEVSTRT')=0) or
    ((StrComp(Tag^.Name,'DOORSTRT')=0) and (Entry^.Size=4096) and (StrComp(Entry^.Name,'SDOOR4A')<>0)) or
    (StrComp(Tag^.Name,'SIDESTRT')=0);
end;

function IsFloor(Index:longint):boolean;
var
  I:longint;
  Tag:PWadEntry;
begin
  IsFloor:=False;
  I:=GetEntryTag(Index);
  if I=-1 then
    Exit;

  Tag:=WadDir^.Entries[I];
  IsFloor:=StrComp(Tag^.Name,'UPDNSTRT')=0;
end;

function IsSky(Index:longint):boolean;
var
  I:longint;
  Tag:PWadEntry;
begin
  IsSky:=False;
  I:=GetEntryTag(Index);
  if I=-1 then
    Exit;

  Tag:=WadDir^.Entries[I];
  IsSky:=StrComp(Tag^.Name,'SKYSTART')=0;
end;

function IsPicture(Index:longint):boolean;
var
  I:longint;
  Tag,Entry:PWadEntry;
begin
  IsPicture:=False;
  I:=GetEntryTag(Index);
  if I=-1 then
    Exit;

  Tag:=WadDir^.Entries[I];
  Entry:=WadDir^.Entries[Index];
  IsPicture:=(StrComp(Tag^.Name,'ABVMSTRT')=0) or
    (StrComp(Tag^.Name,'GUNSTART')=0) or
    ((StrComp(Tag^.Name,'DOORSTRT')=0) and (Entry^.Size<>4096)) or
    (StrComp(Entry^.Name,'SDOOR4A')=0) or
    (StrComp(Entry^.Name,'HSWITCH3')=0) or
    (StrComp(Entry^.Name,'HSWTICH4')=0) or
    (StrComp(Tag^.Name,'SHAPSTRT')=0);
end;

function IsTransPicture(Index:longint):boolean;
var
  I:longint;
  Tag,Entry:PWadEntry;
begin
  IsTransPicture:=False;
  I:=GetEntryTag(Index);
  if I=-1 then
    Exit;

  Tag:=WadDir^.Entries[I];
  Entry:=WadDir^.Entries[Index];
  IsTransPicture:=((StrComp(Tag^.Name,'EXITSTRT')=0) and (Entry^.Size<>4096)) or
    ((StrComp(Tag^.Name,'HMSKSTRT')=0) and (StrComp(Entry^.Name,'HSWITCH')<>0) and
      (StrComp(Entry^.Name,'HSWTICH4')<>0)) or
    (StrComp(Tag^.Name,'MASKSTRT')=0);
end;

begin
  WadFilename:=nil;
  WadDir:=nil;
  LevelFilename:=nil;
  LevelDir:=nil;
  WallDefs:=nil;
  SpriteDefs:=nil;
  InfoDefs:=nil;
end.