unit REEdit;
{$I-}
interface

procedure EditLevel;

implementation
uses
  Crt,Strings,REGlbls,REGraph,REWads,REDefs,RELvls;

const
  em_Walls=1;
  em_Sprites=2;
  em_Info=3;

var
  PageSizeX,PageSizeY:integer;
  ScrollPosX,ScrollPosY:integer;
  RepaintLevel,RepaintStatusbar:boolean;
  ViewWalls,ViewSprites,ViewInfo:boolean;
  IsDrawing:boolean;
  EditMode:word;
  WallObject,SpriteObject,InfoObject,EditObject:word;

procedure Wait(Prompt:PChar);
var
  I,J:integer;
  Quit:boolean;
  Event:word;
begin
  for I:=0 to 319 do
    for J:=190 to 199 do
      mem[VideoSegment:J*320+I]:=0;
  WriteStr(0,192,Prompt);

  Quit:=False;
  ClearEvents;
  repeat
    Event:=GetMouseEvent;
    Quit:=(GetKeyEvent<>ke_Nothing) or ((Event<>me_Nothing) and (Event<>me_Move));
  until Quit;
  ClearEvents;

  RepaintStatusbar:=True;
end;

function GetString(Prompt,Default,Buffer:PChar; MaxLen:word):PChar;
var
  I,J:integer;
  Key:char;
  L:word;
begin
  StrCopy(Buffer,'');
  repeat
    for I:=0 to 319 do
      for J:=190 to 199 do
        mem[VideoSegment:J*320+I]:=0;
    WriteStr(0,192,Prompt);
    WriteStr(StrLen(Prompt)*4,192,': ');
    WriteStr((StrLen(Prompt)+2)*4,192,Buffer);
    Key:=ReadKey;
    L:=StrLen(Buffer);
    case Key of
      #0:
        ReadKey;
      #8:
        if L>0 then
          Buffer[L-1]:=#0;
      #32..#255:
        if L<MaxLen then begin
          Buffer[L]:=Key;
          Buffer[L+1]:=#0;
        end;
      #13:
        GetString:=Buffer;
      #27:
        GetString:=nil;
    end;
  until (Key=#13) or (Key=#27);

  RepaintStatusbar:=True;
end;

procedure ScrollTo(X,Y:integer);
begin
  if X<0 then
    X:=0;
  if X>PlaneSize-PageSizeX+1 then
    X:=PlaneSize-PageSizeX+1;
  if Y<0 then
    Y:=0;
  if Y>PlaneSize-PageSizeY+1 then
    Y:=PlaneSize-PageSizeY+1;

  if (ScrollPosX<>X) or (ScrollPosY<>Y) then begin
    ScrollPosX:=X;
    ScrollPosY:=Y;
    RepaintLevel:=True;
    RepaintStatusbar:=True;
  end;
end;

procedure ScrollDelta(DX,DY:integer);
begin
  ScrollTo(ScrollPosX+DX,ScrollPosY+DY);
end;

procedure PaintEmpty(X,Y:integer);
var
  I,J:integer;
begin
  for I:=0 to IconSize-1 do
    for J:=0 to IconSize-1 do
      if (I+X<320) and (J+Y<190) then
        mem[VideoSegment:(J+Y)*320+I+X]:=0;
end;

procedure PaintWall(X,Y:integer; Wall:word);
var
  PD:PPlaneDef;
  I,J:integer;
begin
  PD:=WallDefs;
  while PD<>nil do begin
    if PD^.Id=Wall then
      Break;
    PD:=PD^.Next;
  end;

  if (PD=nil) or (PD^.Icon=nil) then begin
    for I:=0 to IconSize-1 do
      for J:=0 to IconSize-1 do
        if (I+X<320) and (J+Y<190) then
          mem[VideoSegment:(J+Y)*320+I+X]:=Wall;
  end else begin
    for I:=0 to IconSize-1 do
      for J:=0 to IconSize-1 do
        if (I+X<320) and (J+Y<190) then
          mem[VideoSegment:(J+Y)*320+I+X]:=PD^.Icon^.Data[J*IconSize+I];
  end;
end;

procedure PaintSprite(X,Y:integer; Sprite:word);
var
  PD:PPlaneDef;
  I,J:integer;
  C:byte;
begin
  if Sprite=0 then
    Exit;

  PD:=SpriteDefs;
  while PD<>nil do begin
    if PD^.Id=Sprite then
      Break;
    PD:=PD^.Next;
  end;

  if (PD=nil) or (PD^.Icon=nil) then begin
    for I:=IconSize div 4 to IconSize*3 div 4 do
      for J:=IconSize div 4 to IconSize*3 div 4 do
        if (I+X<320) and (J+Y<190) then
          mem[VideoSegment:(J+Y)*320+I+X]:=Sprite;
  end else begin
    for I:=0 to IconSize-1 do
      for J:=0 to IconSize-1 do
        if (I+X<320) and (J+Y<190) then begin
          C:=PD^.Icon^.Data[J*IconSize+I];
          if C<>255 then
            mem[VideoSegment:(J+Y)*320+I+X]:=C;
        end;
  end;
end;

procedure PaintInfo(X,Y:integer; Info:word);
var
  PD:PPlaneDef;
  I,J:integer;
  C:byte;
begin
  if Info=0 then
    Exit;

  PD:=InfoDefs;
  while PD<>nil do begin
    if PD^.Id=Info then
      Break;
    PD:=PD^.Next;
  end;

  if (PD=nil) or (PD^.Icon=nil) then
    Exit;

  for I:=0 to IconSize-1 do
    for J:=0 to IconSize-1 do
      if (I+X<320) and (J+Y<190) then begin
        C:=PD^.Icon^.Data[J*IconSize+I];
        if C<>255 then
          mem[VideoSegment:(J+Y)*320+I+X]:=C;
      end;
end;

procedure PaintLevel;
var
  I,J,P:integer;
begin
  HideMouse;
  for I:=0 to PageSizeX-1 do
    for J:=0 to PageSizeY-1 do
      if (ScrollPosX+I<PlaneSize) and (ScrollPosY+J<PlaneSize) then begin
        P:=(J+ScrollPosY)*PlaneSize+ScrollPosX+I;
        if ViewWalls then
          PaintWall(I*IconSize,J*IconSize,WallPlane^[P])
        else
          PaintEmpty(I*IconSize,J*IconSize);
        if ViewInfo then
          PaintInfo(I*IconSize,J*IconSize,InfoPlane^[P]);
        if ViewSprites then
          PaintSprite(I*IconSize,J*IconSize,SpritePlane^[P]);
      end else
        PaintEmpty(I*IconSize,J*IconSize);
  ShowMouse;
  RepaintLevel:=False;
end;

procedure PaintStatusbar;
var
  X,Y:integer;
  MB,MX,MY:word;
  S:array[0..6] of char;
  Id:word;
  Defs:PPlaneDef;
begin
  HideMouse;
  for X:=0 to 319 do
    for Y:=190 to 199 do
      mem[VideoSegment:Y*320+X]:=0;
  ShowMouse;

  GetMouseState(MB,MX,MY);
  X:=ScrollPosX+MX div IconSize;
  Y:=ScrollPosY+MY div IconSize;
  if (X>PlaneSize-1) or (Y>PlaneSize-1) then
    Exit;

  HideMouse;
  if ViewWalls then
    WriteStr(0,192,'W');
  if ViewSprites then
    WriteStr(1*4,192,'S');
  if ViewInfo then
    WriteStr(2*4,192,'I');

  Str(X:3,S);
  WriteStr(4*4,192,S);
  WriteStr(7*4,192,',');
  Str(Y:3,S);
  WriteStr(8*4,192,S);

  case EditMode of
    em_Walls:
      begin
        WriteStr(12*4,192,'W');
        Id:=WallPlane^[Y*PlaneSize+X];
        Defs:=WallDefs;
      end;
    em_Sprites:
      begin
        WriteStr(12*4,192,'S');
        Id:=SpritePlane^[Y*PlaneSize+X];
        Defs:=SpriteDefs;
      end;
    em_Info:
      begin
        WriteStr(12*4,192,'I');
        Id:=InfoPlane^[Y*PlaneSize+X];
        Defs:=InfoDefs;
      end;
  end;

  Str(Id:5,S);
  WriteStr(14*4,192,S);
  while Defs<>nil do
    if Defs^.Id=Id then begin
      WriteStr(20*4,192,Defs^.Description);
      Break;
    end else
      Defs:=Defs^.Next;

  if (EditMode=em_Info) and (Defs=nil) then begin
    if Id>=57856 then begin
      WriteStr(20*4,192,'Next level:');
      Str(Id-57856:5,S);
      WriteStr(32*4,192,S);
    end else if Id>=45056 then begin
      WriteStr(20*4,192,'Height:');
      if Id>=45296 then
        Str(Integer(Id-45312):5,S)
      else
        Str(Id-45056,S);
      WriteStr(28*4,192,S);
    end else begin
      WriteStr(20*4,192,'XY position or delay time:');
      Str(Id div 256:3,S);
      WriteStr(47*4,192,S);
      WriteStr(50*4,192,',');
      Str(Id mod 256:3,S);
      WriteStr(51*4,192,S);
    end;
  end;

  ShowMouse;
  RepaintStatusbar:=False;
end;

procedure UpdateScroller;
var
  MB,MX,MY:word;
begin
  GetMouseState(MB,MX,MY);
  if MX=0 then
    ScrollDelta(-1,0);
  if MX=319 then
    ScrollDelta(1,0);
  if MY=0 then
    ScrollDelta(0,-1);
  if MY=199 then
    ScrollDelta(0,1);
end;

procedure DrawObject;
var
  MB,MX,MY:word;
  X,Y,P:integer;
  Plane:PLevelPlane;
  Id:word;
begin
  GetMouseState(MB,MX,MY);
  X:=ScrollPosX+MX div IconSize;
  Y:=ScrollPosY+MY div IconSize;
  if (X>PlaneSize-1) or (Y>PlaneSize-1) then
    Exit;

  case EditMode of
    em_Walls:
      Plane:=WallPlane;
    em_Sprites:
      Plane:=SpritePlane;
    em_Info:
      Plane:=InfoPlane;
  end;
  if Plane^[Y*PlaneSize+X]=EditObject then
    Exit;
  Plane^[Y*PlaneSize+X]:=EditObject;

  HideMouse;
  P:=Y*PlaneSize+X;
  if ViewWalls then
    PaintWall((X-ScrollPosX)*IconSize,(Y-ScrollPosY)*IconSize,WallPlane^[P])
  else
    PaintEmpty((X-ScrollPosX)*IconSize,(Y-ScrollPosY)*IconSize);
  if ViewInfo then
    PaintInfo((X-ScrollPosX)*IconSize,(Y-ScrollPosY)*IconSize,InfoPlane^[P]);
  if ViewSprites then
    PaintSprite((X-ScrollPosX)*IconSize,(Y-ScrollPosY)*IconSize,SpritePlane^[P]);
  ShowMouse;

  RepaintStatusbar:=True;
end;

procedure MeMove;
begin
  if IsDrawing then
    DrawObject;
  RepaintStatusbar:=True;
end;

procedure MeLeftDown;
begin
  IsDrawing:=True;
  DrawObject;
end;

procedure MeLeftUp;
begin
  IsDrawing:=False;
end;

procedure MeRightDown;
var
  MB,MX,MY:word;
  X,Y:integer;
begin
  GetMouseState(MB,MX,MY);
  X:=ScrollPosX+MX div IconSize;
  Y:=ScrollPosY+MY div IconSize;
  if (X>PlaneSize-1) or (Y>PlaneSize-1) then
    Exit;

  case EditMode of
    em_Walls:
      EditObject:=WallPlane^[Y*PlaneSize+X];
    em_Sprites:
      EditObject:=SpritePlane^[Y*PlaneSize+X];
    em_Info:
      EditObject:=InfoPlane^[Y*PlaneSize+X];
  end;

  RepaintStatusbar:=True;
end;

procedure CmHelp;
begin
  HideMouse;
  ClearScreen(0);
  WriteStr(0,0,'Keys');
  WriteStr(0,1*7,'  F1  Show this help screen');
  WriteStr(0,2*7,'  F2  Show map');
  WriteStr(0,3*7,'  F3  Toggle walls');
  WriteStr(0,4*7,'  F4  Toggle sprites');
  WriteStr(0,5*7,'  F5  Toggle info');
  WriteStr(0,6*7,'  F6  Toggle active plane');
  WriteStr(0,7*7,'  F7  Select object by list');
  WriteStr(0,8*7,'  F8  Select object by id');
  WriteStr(0,9*7,'  SF8 Select object by XY position or delay time');
  WriteStr(0,10*7,'  CF8 Select object by height');
  WriteStr(0,11*7,'  AF8 Select object by next level');

  WriteStr(0,13*7,'Mouse buttons');
  WriteStr(0,14*7,'  Left  Draw object');
  WriteStr(0,15*7,'  Right Select object at cursor');
  ShowMouse;

  Wait('Press any key to continue...');

  RepaintLevel:=True;
  RepaintStatusbar:=True;
end;

procedure CmMap;
var
  X,Y,I,J:integer;
  Quit:boolean;
  MB,MX,MY:word;
begin
  HideMouse;
  X:=(320-PlaneSize) div 2;
  Y:=(200-PlaneSize) div 2;
  Rectangle(X-1,Y-1,PlaneSize+2,PlaneSize+2,RGB(63,63,63));
  for I:=0 to PlaneSize-1 do
    for J:=0 to PlaneSize-1 do
      mem[VideoSegment:(Y+J)*320+X+I]:=WallPlane^[J*PlaneSize+I];
  Rectangle(X+ScrollPosX,Y+ScrollPosY,PageSizeX,PageSizeY,RGB(63,63,63));
  ShowMouse;

  Quit:=False;
  ClearEvents;
  repeat
    case GetMouseEvent of
      me_LeftDown:
        begin
          GetMouseState(MB,MX,MY);
          if (MX>=X) and (MX<X+PlaneSize) and
            (MY>=Y) and (MY<Y+PlaneSize) then
              ScrollTo(MX-X-PageSizeX div 2,MY-Y-PageSizeY div 2);
          Quit:=True;
        end;
    end;
    if GetKeyEvent<>ke_Nothing then
      Quit:=True;
  until Quit;
  ClearEvents;

  ShowMouse;
  RepaintLevel:=True;
end;

procedure CmToggleWalls;
begin
  ViewWalls:=not ViewWalls;
  RepaintLevel:=True;
  RepaintStatusbar:=True;
end;

procedure CmToggleSprites;
begin
  ViewSprites:=not ViewSprites;
  RepaintLevel:=True;
  RepaintStatusbar:=True;
end;

procedure CmToggleInfo;
begin
  ViewInfo:=not ViewInfo;
  RepaintLevel:=True;
  RepaintStatusbar:=True;
end;

procedure CmToggleEditMode;
begin
  case EditMode of
    em_Walls:
      begin
        WallObject:=EditObject;
        EditObject:=SpriteObject;
        EditMode:=em_Sprites;
      end;
    em_Sprites:
      begin
        SpriteObject:=EditObject;
        EditObject:=InfoObject;
        EditMode:=em_Info;
      end;
    em_Info:
      begin
        InfoObject:=EditObject;
        EditObject:=WallObject;
        EditMode:=em_Walls;
      end;
  end;
  RepaintStatusbar:=True;
end;

procedure CmSelectObjectByList;
var
  List,First:PPlaneDef;
  RepaintList:boolean;

  procedure PaintList;
  var
    PD:PPlaneDef;
    I,J,K:integer;
    S:array[0..5] of char;
  begin
    HideMouse;
    ClearScreen(0);
    PD:=First;
    K:=0;
    while (PD<>nil) and (K<200 div IconSize+1) do begin
      if PD^.Icon=nil then begin
        for I:=0 to IconSize-1 do
          for J:=0 to IconSize-1 do
            if (I<320) and (J+K*IconSize<200) then
              mem[VideoSegment:(J+K*IconSize)*320+I]:=PD^.Id;
      end else begin
        for I:=0 to IconSize-1 do
          for J:=0 to IconSize-1 do
            if (I<320) and (J+K*IconSize<200) then
              mem[VideoSegment:(J+K*IconSize)*320+I]:=PD^.Icon^.Data[J*IconSize+I];
      end;
      Str(PD^.Id:5,S);
      WriteStr(20,K*IconSize+4,S);
      WriteStr(20+6*4,K*IconSize+4,PD^.Description);
      PD:=PD^.Next;
      K:=K+1;
    end;
    ShowMouse;
    RepaintList:=False;
  end;

  procedure ScrollList;
  var
    MB,MX,MY:word;
    PD:PPlaneDef;
  begin
    GetMouseState(MB,MX,MY);
    if (MY=0) and (First<>List) then begin
      PD:=List;
      while PD^.Next<>First do
        PD:=PD^.Next;
      First:=PD;
      RepaintList:=True;
    end;
    if (MY=199) and (First^.Next<>nil) then begin
      First:=First^.Next;
      RepaintList:=True;
    end;
  end;

var
  Quit:boolean;
  PD:PPlaneDef;
  I:integer;
  MB,MX,MY:word;

begin
  case EditMode of
    em_Walls:
      List:=WallDefs;
    em_Sprites:
      List:=SpriteDefs;
    em_Info:
      List:=InfoDefs;
  end;
  First:=List;
  RepaintList:=True;

  Quit:=False;
  repeat
    if RepaintList then
      PaintList;
    ScrollList;
    case GetMouseEvent of
      me_LeftDown:
        begin
          GetMouseState(MB,MX,MY);
          PD:=First;
          I:=0;
          while (PD<>nil) and (I<200 div IconSize+1) do begin
            if (MY>=I*IconSize) and (MY<(I+1)*IconSize) then begin
              EditObject:=PD^.Id;
              Break;
            end;
            PD:=PD^.Next;
            I:=I+1;
          end;
        Quit:=True;
      end;
    end;
    case GetKeyEvent of
      ke_Esc:
        Quit:=True;
    end;
  until Quit;

  RepaintLevel:=True;
  RepaintStatusbar:=True;
end;

procedure CmSelectObjectById;
var
  Buffer:array[0..5] of char;
  Id,R:word;
begin
  if GetString('Enter id',nil,Buffer,5)=nil then
    Exit;

  Val(Buffer,Id,R);
  if R<>0 then begin
    Wait('Invalid numeric format.');
    Exit;
  end;

  EditObject:=Id;
end;

procedure CmSelectObjectByXY;
var
  Buffer:array[0..5] of char;
  X,Y,R:word;
begin
  if EditMode<>em_Info then
    Exit;

  if GetString('X position/minutes',nil,Buffer,5)=nil then
    Exit;
  Val(Buffer,X,R);
  if R<>0 then begin
    Wait('Invalid numeric format.');
    Exit;
  end;
  if GetString('Y position/seconds',nil,Buffer,5)=nil then
    Exit;
  Val(Buffer,Y,R);
  if R<>0 then begin
    Wait('Invalid numeric format.');
    Exit;
  end;
  EditObject:=X*256+Y;
end;

procedure CmSelectObjectByHeight;
var
  Buffer:array[0..6] of char;
  H:integer;
  R:word;
begin
  if EditMode<>em_Info then
    Exit;

  if GetString('Height',nil,Buffer,6)=nil then
    Exit;
  Val(Buffer,H,R);
  if R<>0 then begin
    Wait('Invalid numeric format.');
    Exit;
  end;
  if H<0 then
    EditObject:=45312+H
  else
    EditObject:=45056+H;
end;

procedure CmSelectObjectByEndLevel;
var
  Buffer:array[0..5] of char;
  W,R:word;
begin
  if EditMode<>em_Info then
    Exit;

  if GetString('Level number or 255 for game end',nil,Buffer,5)=nil then
    Exit;
  Val(Buffer,W,R);
  if R<>0 then begin
    Wait('Invalid numeric format.');
    Exit;
  end;
  EditObject:=57856+W;
end;

procedure EditLevel;
var
  Quit:boolean;
begin
  InitGraphics;
  SetPalette(LoadPalette('rotten.pal'));
  SetFont(LoadFont('rotten.fon'));
  ShowMouse;

  PageSizeX:=320 div IconSize+1;
  PageSizeY:=200 div IconSize+1;
  ScrollPosX:=0;
  ScrollPosY:=0;
  RepaintLevel:=True;
  RepaintStatusbar:=True;
  ViewWalls:=True;
  ViewSprites:=True;
  ViewInfo:=True;
  IsDrawing:=False;
  EditMode:=em_Walls;
  WallObject:=0;
  SpriteObject:=0;
  InfoObject:=0;

  Quit:=False;
  repeat
    if RepaintLevel then
      PaintLevel;
    if RepaintStatusbar then
      PaintStatusbar;
    UpdateScroller;
    case GetMouseEvent of
      me_Move:
        MeMove;
      me_LeftDown:
        MeLeftDown;
      me_LeftUp:
        MeLeftUp;
      me_RightDown:
        MeRightDown;
    end;
    case GetKeyEvent of
      ke_F1:
        CmHelp;
      ke_F2:
        CmMap;
      ke_F3:
        CmToggleWalls;
      ke_F4:
        CmToggleSprites;
      ke_F5:
        CmToggleInfo;
      ke_F6:
        CmToggleEditMode;
      ke_F7:
        CmSelectObjectByList;
      ke_F8:
        CmSelectObjectById;
      ke_SF8:
        CmSelectObjectByXY;
      ke_CF8:
        CmSelectObjectByHeight;
      ke_AF8:
        CmSelectObjectByEndLevel;
      ke_Esc:
        Quit:=True;
    end;
  until Quit;

  HideMouse;
  DeleteFont(SetFont(nil));
  DeletePalette(SetPalette(nil));
  DoneGraphics;
end;

begin
end.