unit REDefs;
{$I-}
interface
uses
  REGraph;

const
  IconSize=16; { breedte en hoogte }

  cia_Bottom=0;
  cia_Top=1;

type
  PPlaneDef=^TPlaneDef;
  TPlaneDef=record
    Id:word;
    Icon:PBitmap;
    Description:PChar;
    Next:PPlaneDef;
  end;

function CreateIcon(Bitmap:PBitmap; Alignment:word):PBitmap;
function CompilePlaneDefs(Filename:PChar):PPlaneDef;
procedure DeletePlaneDefs(PlaneDefs:PPlaneDef);
function WritePlaneDefs(Filename:PChar; PlaneDefs:PPlaneDef):boolean;
function ReadPlaneDefs(Filename:PChar):PPlaneDef;

implementation
uses
  Strings,REGlbls,REWads;

function CreateIcon(Bitmap:PBitmap; Alignment:word):PBitmap;
var
  Icon:PBitmap;
  I,J,DeltaX,DeltaY:integer;
begin
  Icon:=CreateBitmap(IconSize,IconSize);
  if (Bitmap^.Width=64) and (Bitmap^.Height=64) then
    for I:=0 to IconSize-1 do
      for J:=0 to IconSize-1 do
        Icon^.Data[J*IconSize+I]:=Bitmap^.Data[J*64 div IconSize*64+I*64 div IconSize]
  else if (Bitmap^.Width=64) and (Bitmap^.Height=44) then begin
    if Alignment=cia_Top then
      DeltaY:=0
    else
      DeltaY:=IconSize*20 div 64;
    for I:=0 to IconSize-1 do
      for J:=0 to (IconSize*44 div 64)-1 do
        Icon^.Data[(J+DeltaY)*IconSize+I]:=Bitmap^.Data[J*64 div IconSize*64+I*64 div IconSize]
  end else if (Bitmap^.Width<=128) and (Bitmap^.Height<=128) then begin
    DeltaX:=IconSize*(128-Bitmap^.Width) div (2*128);
    if Alignment=cia_Top then
      DeltaY:=0
    else
      DeltaY:=IconSize*(128-Bitmap^.Height) div 128;
    for I:=0 to (IconSize*Bitmap^.Width div 128)-1 do
      for J:=0 to (IconSize*Bitmap^.Height div 128)-1 do
        Icon^.Data[(J+DeltaY)*IconSize+I+DeltaX]:=
          Bitmap^.Data[J*128 div IconSize*Bitmap^.Width+I*128 div IconSize];
  end else if (Bitmap^.Width=256) and (Bitmap^.Height=200) then begin
    for I:=0 to IconSize-1 do
      for J:=0 to IconSize-1 do
        Icon^.Data[J*IconSize+I]:=
          Bitmap^.Data[J*200 div IconSize*256+I*200 div IconSize];
  end;
  CreateIcon:=Icon;
end;

function CompilePlaneDefs(Filename:PChar):PPlaneDef;
var
  Str,Arg:array[0..255] of char;
  I:word;

  function GetNextArg:boolean;
  var
    L:word;
  begin
    GetNextArg:=False;
    StrCopy(Arg,'');
    L:=0;
    while (Str[I]=#9) or (Str[I]=' ') do
      I:=I+1;
    if (Str[I]<>';') and (Str[I]<>#0) then begin
      if Str[I]<>'"' then begin
        WriteLn(Str);
        WriteLn('Arguments must start with ''"''.');
        Exit;
      end;
      I:=I+1;
      while (Str[I]<>'"') and (Str[I]<>#0) do begin
        Arg[L]:=Str[I];
        Arg[L+1]:=#0;
        I:=I+1;
        L:=L+1;
      end;
      if Str[I]<>'"' then begin
        WriteLn(Str);
        WriteLn('Arguments must end with ''"''.');
        Exit;
      end;
    end;
    GetNextArg:=True;
  end;

var
  F:text;
  IdStr,IconStr,AlignStr,DescStr:PChar;
  Id,R:word;
  J:longint;
  Bitmap,Icon:PBitmap;
  PD,P:PPlaneDef;

begin
  CompilePlaneDefs:=nil;
  Assign(F,Filename);
  Reset(F);
  if IOResult<>0 then begin
    WriteLn('Error opening file ''',Filename,'''.');
    Exit;
  end;

  PD:=nil;
  P:=nil;
  while not Eof(F) do begin
    ReadLn(F,Str);
    I:=0;
    IdStr:=nil;
    IconStr:=nil;
    AlignStr:=nil;
    DescStr:=nil;
    if not GetNextArg then begin
      DeletePlaneDefs(PD);
      Close(F);
      Exit;
    end;
    if (Str[I]=';') or (Str[I]=#0) then
      Continue;
    IdStr:=StrNew(Arg);
    I:=I+1;
    if not GetNextArg then begin
      StrDispose(IdStr);
      DeletePlaneDefs(PD);
      Close(F);
      Exit;
    end;
    IconStr:=StrNew(Arg);
    if (Str[I]<>';') and (Str[I]<>#0) then begin
      I:=I+1;
      if not GetNextArg then begin
        StrDispose(IdStr);
        StrDispose(IconStr);
        DeletePlaneDefs(PD);
        Close(F);
        Exit;
      end;
      AlignStr:=StrNew(Arg);
      if (Str[I]<>';') and (Str[I]<>#0) then begin
        I:=I+1;
        if not GetNextArg then begin
          StrDispose(IdStr);
          StrDispose(IconStr);
          StrDispose(AlignStr);
          DeletePlaneDefs(PD);
          Close(F);
          Exit;
        end;
        DescStr:=StrNew(Arg);
      end;
    end;

    Val(IdStr,Id,R);
    if R<>0 then begin
      WriteLn(Str);
      WriteLn('Invalid numeric format.');
      StrDispose(IdStr);
      StrDispose(IconStr);
      StrDispose(AlignStr);
      StrDispose(DescStr);
      DeletePlaneDefs(PD);
      Close(F);
      Exit;
    end;

    if (IconStr<>nil) and (StrLen(IconStr)<>0) then begin
      J:=WadEntryWithName(IconStr);
      if J=-1 then begin
        WriteLn(Str);
        WriteLn('Invalid icon name.');
        StrDispose(IdStr);
        StrDispose(IconStr);
        StrDispose(AlignStr);
        StrDispose(DescStr);
        DeletePlaneDefs(PD);
        Close(F);
        Exit;
      end;

      if IsWall(J) then
        Bitmap:=ReadWall(WadFilename,WadDir^.Entries[J]^.Offset,WadDir^.Entries[J]^.Size)
      else if IsFloor(J) then
        Bitmap:=ReadFloor(WadFilename,WadDir^.Entries[J]^.Offset,WadDir^.Entries[J]^.Size)
      else if IsSky(J) then
        Bitmap:=ReadSky(WadFilename,WadDir^.Entries[J]^.Offset,WadDir^.Entries[J]^.Size)
      else if IsPicture(J) then
        Bitmap:=ReadPicture(WadFilename,WadDir^.Entries[J]^.Offset,WadDir^.Entries[J]^.Size)
      else if IsTransPicture(J) then
        Bitmap:=ReadTransPicture(WadFilename,WadDir^.Entries[J]^.Offset,WadDir^.Entries[J]^.Size)
      else begin
        WriteLn(Str);
        WriteLn('Invalid icon type.');
        StrDispose(IdStr);
        StrDispose(IconStr);
        StrDispose(AlignStr);
        StrDispose(DescStr);
        DeletePlaneDefs(PD);
        Close(F);
        Exit;
      end;

      if (AlignStr=nil) or (StrLen(AlignStr)=0) or (StrComp(AlignStr,'0')=0) then
        Icon:=CreateIcon(Bitmap,cia_Bottom)
      else if StrComp(AlignStr,'1')=0 then
        Icon:=CreateIcon(Bitmap,cia_Top)
      else begin
        WriteLn(Str);
        WriteLn('Invalid alignment type.');
        DeleteBitmap(Bitmap);
        StrDispose(IdStr);
        StrDispose(IconStr);
        StrDispose(AlignStr);
        StrDispose(DescStr);
        DeletePlaneDefs(PD);
        Close(F);
        Exit;
      end;
      DeleteBitmap(Bitmap);
    end else
      Icon:=nil;

    StrDispose(IdStr);
    StrDispose(IconStr);
    StrDispose(AlignStr);

    if PD=nil then begin
      New(PD);
      P:=PD;
    end else begin
      New(P^.Next);
      P:=P^.Next;
    end;
    P^.Id:=Id;
    P^.Icon:=Icon;
    P^.Description:=DescStr;
    P^.Next:=nil;
  end;
  Close(F);
  CompilePlaneDefs:=PD;
end;

procedure DeletePlaneDefs(PlaneDefs:PPlaneDef);
var
  N:PPlaneDef;
begin
  while PlaneDefs<>nil do begin
    N:=PlaneDefs^.Next;
    DeleteBitmap(PlaneDefs^.Icon);
    StrDispose(PlaneDefs^.Description);
    Dispose(PlaneDefs);
    PlaneDefs:=N;
  end;
end;

function WritePlaneDefs(Filename:PChar; PlaneDefs:PPlaneDef):boolean;
var
  F:file;
  L:word;
  PD:PPlaneDef;
begin
  WritePlaneDefs:=False;
  Assign(F,Filename);
  Rewrite(F,1);
  if IOResult<>0 then begin
    WriteLn('Error opening file ''',Filename,'''.');
    Exit;
  end;

  PD:=PlaneDefs;
  while PD<>nil do begin
    BlockWrite(F,PD^.Id,2);
    if PD^.Icon=nil then begin
      L:=0;
      BlockWrite(F,L,2);
      BlockWrite(F,L,2);
    end else begin
      BlockWrite(F,PD^.Icon^.Width,2);
      BlockWrite(F,PD^.Icon^.Height,2);
      BlockWrite(F,PD^.Icon^.Data,PD^.Icon^.Width*PD^.Icon^.Height);
    end;
    if PD^.Description=nil then begin
      L:=0;
      BlockWrite(F,L,2);
    end else begin
      L:=StrLen(PD^.Description)+1;
      BlockWrite(F,L,2);
      BlockWrite(F,PD^.Description^,L);
    end;
    if IOResult<>0 then begin
      WriteLn('Error writing to file ''',Filename,'''.');
      Close(F);
      Exit;
    end;
    PD:=PD^.Next;
  end;
  WritePlaneDefs:=True;
end;

function ReadPlaneDefs(Filename:PChar):PPlaneDef;
var
  F:file;
  W,H:integer;
  L:word;
  PD,P:PPlaneDef;
begin
  ReadPlaneDefs:=nil;
  Assign(F,Filename);
  Reset(F,1);
  if IOResult<>0 then begin
    WriteLn('Error opening file ''',Filename,'''.');
    Exit;
  end;

  PD:=nil;
  P:=nil;
  while not Eof(F) do begin
    if PD=nil then begin
      New(PD);
      P:=PD;
    end else begin
      New(P^.Next);
      P:=P^.Next;
    end;
    BlockRead(F,P^.Id,2);
    BlockRead(F,W,2);
    BlockRead(F,H,2);
    if (W=0) or (H=0) then
      P^.Icon:=nil
    else begin
      P^.Icon:=CreateBitmap(W,H);
      BlockRead(F,P^.Icon^.Data,W*H);
    end;
    BlockRead(F,L,2);
    if L=0 then
      P^.Description:=nil
    else begin
      GetMem(P^.Description,L);
      BlockRead(F,P^.Description^,L);
    end;
    P^.Next:=nil;
    if IOResult<>0 then begin
      WriteLn('Error reading from file ''',Filename,'''.');
      DeletePlaneDefs(PD);
      Exit;
    end;
  end;
  ReadPlaneDefs:=PD;
end;

begin
end.