/*

   MAP.H

   Oliver Kraus
   kraus@lrs.e-technik.uni-erlangen.de

*/


#ifndef _MAP_H
#define _MAP_H

#include <stdio.h>

struct _map_player_struct
{
   long x;
   long y;
   long z;           /* Note: Z coordinates are all shifted up 4 */
   short ang;        /* All angles are from 0-2047, clockwise */
   short secnum;     /* Sector of starting point */
};
typedef struct _map_player_struct map_player_struct;
typedef struct _map_player_struct *map_player_type;

struct _map_sector_struct
{
   short wallptr;             /* index to first wall of sector */
   short wallnum;             /* number of walls in sector */
   long ceilingz;             /* z coordinate (height) of ceiling */
   long floorz;               /* floor at first point of sector */
   /*
   bit 0: 1 = parallaxing, 0 = not                                 "P"
   bit 1: 1 = sloped, 0 = not
   bit 2: 1 = swap x&y, 0 = not                                    "F"
   bit 3: 1 = double smooshiness                                   "E"
   bit 4: 1 = x-flip                                               "F"
   bit 5: 1 = y-flip                                               "F"
   bit 6: 1 = Align texture to first wall of sector                "R"
   bits 7-15: reserved
   */
   short ceilingstat;
   short floorstat;

   short ceilingpicnum;       /* texture index into art file */
   short ceilingheinum;       /* slope value (rise/run) (0-parallel to floor, 4096-45 degrees) */

   signed char ceilingshade;  /* shade offset of ceiling/floor */
   char ceilingpal;           /* palette lookup table number (0 - use std colors) */
   char ceilingxpanning;      /* used to align textures or to do texture panning */
   char ceilingypanning;      /* used to align textures or to do texture panning */
   short floorpicnum;         /* texture index into art file */
   short floorheinum;         /* slope value (rise/run) (0-parallel to floor, 4096-45 degrees) */
   signed char floorshade;    /* shade offset of ceiling/floor */
   char floorpal;             /* palette lookup table number (0 - use std colors) */
   char floorxpanning;        /* used to align textures or to do texture panning */
   char floorypanning;        /* used to align textures or to do texture panning */
   char visibility;           /* determines how fast an area changes shade relative to distance */
   char filler;               /* useless byte to make structure aligned */
   short lotag;
   short hitag;
   short extra;
};
typedef struct _map_sector_struct map_sector_struct;
typedef struct _map_sector_struct *map_sector_type;

struct _map_wall_struct
{
   long x;            /* Coordinate of left side of wall, get right */
   long y;            /* side from next wall's left side            */
   short point2;      /* Index to next wall on the right (always in the same sector) */
   short nextwall;    /* Index to wall on other side of wall (-1 if there is no sector) */
   short nextsector;  /* Index to sector on other side of wall (-1 if there is no sector) */
   /*
      bit 0: 1 = Blocking wall (use with clipmove, getzrange)         "B"
      bit 1: 1 = bottoms of invisible walls swapped, 0 = not          "2"
      bit 2: 1 = align picture on bottom (for doors), 0 = top         "O"
      bit 3: 1 = x-flipped, 0 = normal                                "F"
      bit 4: 1 = masking wall, 0 = not                                "M"
      bit 5: 1 = 1-way wall, 0 = not                                  "1"
      bit 6: 1 = Blocking wall (use with hitscan / cliptype 1)        "H"
      bit 7: 1 = Transluscence, 0 = not                               "T"
      bit 8: 1 = y-flipped, 0 = normal                                "F"
      bit 9: 1 = Transluscence reversing, 0 = normal                  "T"
      bits 10-15: reserved
   */
   short cstat;
   short picnum;        /* texture index into art file */
   short overpicnum;    /* texture index into art file for masked walls / 1-way walls */
   signed char shade;   /* shade offset of wall */
   char pal;            /* palette lookup table number (0 - use standard colors) */
   char xrepeat;        /* used to change the size of pixels (stretch textures) */
   char yrepeat;        /* used to change the size of pixels (stretch textures) */
   char xpanning;       /* used to align textures or to do texture panning */
   char ypanning;       /* used to align textures or to do texture panning */
   short lotag;
   short hitag;
   short extra;
};
typedef struct _map_wall_struct map_wall_struct;
typedef struct _map_wall_struct *map_wall_type;

struct _map_sprite_struct
{
   long x;                 /* position of sprite - can be defined */
   long y;                 /* at center bottom or center          */
   long z;
   /*
      bit 0: 1 = Blocking sprite (use with clipmove, getzrange)       "B"
      bit 1: 1 = transluscence, 0 = normal                            "T"
      bit 2: 1 = x-flipped, 0 = normal                                "F"
      bit 3: 1 = y-flipped, 0 = normal                                "F"
      bits 5-4: 00 = FACE sprite (default)                            "R"
                01 = WALL sprite (like masked walls)
                10 = FLOOR sprite (parallel to ceilings&floors)
      bit 6: 1 = 1-sided sprite, 0 = normal                           "1"
      bit 7: 1 = Real centered centering, 0 = foot center             "C"
      bit 8: 1 = Blocking sprite (use with hitscan / cliptype 1)      "H"
      bit 9: 1 = Transluscence reversing, 0 = normal                  "T"
      bits 10-14: reserved       (ok: seems to be always zero)
      bit 15: 1 = Invisible sprite, 0 = not invisible
   */
   short cstat;
   short picnum;           /* texture index into art file */
   signed char shade;      /* shade offset of sprite */
   char pal;               /* palette lookup table number (0 - use standard colors) */
   char clipdist;          /* the size of the movement clipping square (face sprites only) */
   char filler;            /* useless byte to make structure aligned */
   unsigned char xrepeat;  /* used to change the size of pixels (stretch textures) */
   unsigned char yrepeat;
   signed char xoffset;    /* used to center the animation of sprites */
   signed char yoffset;
   short sectnum;          /* current sector of sprite */
   short statnum;          /* current status of sprite (inactive/monster/bullet, etc.) */
   short ang;              /* angle the sprite is facing */
   short owner;
   short xvel;
   short yvel;
   short zvel;
   short lotag;
   short hitag;
   short extra;
};
typedef struct _map_sprite_struct map_sprite_struct;
typedef struct _map_sprite_struct *map_sprite_type;


struct _map_struct
{
   char *fname;
   FILE *fp;
   int is_close_fp;

   long version;                 /* should be 7 */

   map_player_struct player;

   short sec_cnt;
   map_sector_struct *sec_list;

   short wall_cnt;
   map_wall_struct *wall_list;

   short sprite_cnt;
   map_sprite_struct *sprite_list;

   long min_x;
   long min_y;
   long max_x;
   long max_y;

   int legend_item_cnt;
};
typedef struct _map_struct map_struct;
typedef struct _map_struct *map_type;

char *map_get_item_id(int idx);
char *map_get_item_string(int idx);
int map_get_item_typ(int idx);
int map_get_item_cnt(int idx);
int map_get_info_idx(short picnum);

int is_map_file(char *name);

map_type map_Open(char *fname, FILE *fp);
void map_Close(map_type map);
int map_Read(map_type map, long pos);
int map_CalculateSize(map_type map);

int map_cnt_sprites(map_type map);

#endif
