	IFND PLAYER_I
PLAYER_I SET 1
**
**	$Filename: Player.i $
**	$Release: 1.0 $
**	$Revision: 5.0A $
**
**	The Player 5.0A definitions
**
**	(C) Copyright 1992-93 Jarno Paananen
**	All Rights Reserved
**

	IFND EXEC_TYPES_I
	include exec/types.i
	ENDC

**********************************************
* The header in front of the binary versions *
**********************************************


  STRUCTURE Player_Header,0
	* Instructions to jump to P50_Init
	ULONG	P50_InitOffset
	* ... to P50_Music (rts, if CIA-Version)
	ULONG	P50_MusicOffset
	* ... to P50_End
	ULONG	P50_EndOffset
	* ... to P50_SetRepeat (if present, otherwise rts)
	ULONG	P50_SetRepeatOffset
	* Master volume (used if told to...)
	UWORD	P50_MasterVolume
	* If non-zero, tempo will be used
	UWORD	P50_UseTempo
	* If zero, playing is stopped
	UWORD	P50_PlayFlag
	* Offset to channel 0 block from the beginning
	APTR	P50_Cha0Offset
	* Offset to channel 1 block from the beginning
	APTR	P50_Cha1Offset
	* Offset to channel 2 block from the beginning
	APTR	P50_Cha2Offset
	* Offset to channel 3 block from the beginning
	APTR	P50_Cha3Offset

	LABEL Player_Header_SIZE


*******************************************************
* The structure of the channel blocks (P50_Temp[0-3]) *
*******************************************************

  STRUCTURE Channel_Block,0

	* Note and the MSB of the sample number
	UBYTE	P50_SN_Note
	* Lower nybble of the sample number and the command
	UBYTE	P50_Command
	* Info byte
	UBYTE	P50_Info
	* Packing info
	UBYTE	P50_Pack
	* Pointer to the sample block of the current sample
	APTR	P50_Sample
	* Current note (offset to the period table)
	UWORD	P50_Note
	* Period
	UWORD	P50_Period
	* Volume (NOT updated in tremolo!)
	UWORD	P50_Volume
	* Current finetune
	UWORD	P50_Fine
	* Sample offset
	UWORD	P50_Offset
	* To period for tone portamento
	UWORD	P50_ToPeriod
	* Speed for tone portamento
	UWORD	P50_TPSpeed
	* Vibrato command
	UBYTE	P50_VibCmd
	* Vibrato position
	UBYTE	P50_VibPos
	* Tremolo command
	UBYTE	P50_TreCmd
	* Tremolo position
	UBYTE	P50_TrePos
	* Retrig note counter
	UWORD	P50_RetrigCount
	* Internal switch to the packing
	UWORD	P50_OnOff
	* Pointer to the current pattern data
	APTR	P50_ChaPos
	* A packing pointer to data elsewhere in the pattern data
	APTR	P50_TempPos
	* Lenght of the temporary positions
	UWORD	P50_TempLen
	* Temp pointers for patternloop
	ULONG	P50_TData
	APTR	P50_TChaPos
	APTR	P50_TTempPos
	UWORD	P50_TTempLen

	* Shadow address to the fading (updated also in tremolo!)
	ifne	fade
	UWORD	P50_Shadow
	endc

	* Bit in the DMACON ($DFF096)
	UWORD	P50_DMABit

	LABEL Channel_Block_SIZE




**********************************************
* The structure of the sample block that     *
* the Player does at the init to P50_Samples *
**********************************************

  STRUCTURE Sample_Block,0

	* Pointer to the beginning of the sample
	APTR	P50_SampleOffset
	* Lenght of the sample
	UWORD	P50_SampleLenght
	* Pointer to the repeat
	APTR	P50_RepeatOffset
	* Lenght of the repeat
	UWORD	P50_RepeatLenght
	* Volume of the sample
	UWORD	P50_SampleVolume
	* Finetune (offset to the period table)
	UWORD	P50_FineTune

	LABEL Sample_Block_SIZE

**********************************************
* Some internal stuff for the Usecode-system *
**********************************************


* if finetune is used
P50_ft = use&1
* portamento up
P50_pu = use&2
* portamento down
P50_pd = use&4
* tone portamento
P50_tp = use&40
* vibrato
P50_vib = use&80
* tone portamento and volume slide
P50_tpvs = use&32
* vibrato and volume slide
P50_vbvs = use&64
* tremolo
P50_tre = use&$80
* arpeggio
P50_arp = use&$100
* sample offset
P50_sof = use&$200
* volume slide
P50_vs = use&$400
* position jump
P50_pj = use&$800
* set volume
P50_vl = use&$1000
* pattern break
P50_pb = use&$2800
* set speed
P50_sd = use&$8000

* E-commands
P50_ec = use&$ffff0000

* filter
P50_fi = use&$10000
* fine slide up
P50_fsu = use&$20000
* fine slide down
P50_fsd = use&$40000
* set finetune
P50_sft = use&$200000
* pattern loop
P50_pl = use&$400000
* retrig note
P50_rt = use&$2000000
* fine volume slide up
P50_fvu = use&$4000000
* fine volume slide down
P50_fvd = use&$8000000
* note cut
P50_nc = use&$10000000
* note delay
P50_nd = use&$20000000
* pattern delay
P50_pde = use&$40000000

   ENDC ; PLAYER_I
